/**
  Copyright (c) 2010 Freescale Semiconductor
  
  \file  	  FLibInternal.h
  \brief	  This is the Flash Library Header Driver File (Internal)
  \brief	  Provides functionality to animate graphics
  \author	  Freescale Semiconductor
  \author	  Automotive Systems Solutions Engineering
  \author	  IM, b06623
  \version	  2.0
  \revision	  $Revision: 47 $
  \date  	  $Date: 2010-10-06 14:50:52 -0500 (Wed, 06 Oct 2010) $  
  
  * History:  5/Jan/2009  - Initial Version
  *			  11/Ago/2010 - Added Size animation to the data structure
  			  6/Oct/2010 - Updated custom animation: functionality OK 

* Copyright (c) 2010, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
  
*/


#ifndef 	_FLIBINTERNAL_H_
#define  	_FLIBINTERNAL_H_

#include	"Flib.h"

/******************************* Internal Data Types **********************************/

/* Animation Structure */
typedef struct
{
    const FLIB_AnimPos_t        *pos;		/**< Defines a position animation */
    const FLIB_AnimAlpha_t      *alpha;		/**< Defines an alpha animation */
    const FLIB_AnimColor_t  	*color;		/**< Defines a color animation */
    const FLIB_AnimScrolling_t 	*scrolling;	/**< Defines a scroll animation */
    const FLIB_AnimScaling_t   	*scaling;	/**< Defines a scaling animation */
    const FLIB_AnimObject_t     *object;	/**< Defines a object animation */
    const FLIB_AnimSize_t		*size;
}FLIB_Animation_t;

typedef struct
{
	uint8_t		rate;
	uint8_t		offset;
	uint32_t	duration;	
	FLIB_CallbackType callback;
	uint32_t	frameLatch;		
}FLIB_CustomAni_t;	


typedef struct
{
    int32_t		y;
    int32_t		x;
    int32_t		dy;
    int32_t		dx;
    
    int32_t	    alpha;
    int32_t		dalpha;
    
    int32_t     scaling;
    int32_t     dscaling;

    int32_t		scry;
    int32_t		scrx;
    int32_t		dscry;
    int32_t		dscrx;
    
    
    uint8_t    	object;   
} FLIB_AnimState_t;

typedef struct
{
    FLIB_AnimState_t state;
    uint32_t duration;
    uint32_t currentFrame;
    FLIB_Animation_t anim;
    FLIB_CallbackAnim_t callback;
    Graphics_Object_t gobject;
}FLIB_AnimLayer_t;

/******************************* Internal Functions **********************************/

void FLIB_CopyGraphicObjectLayer(uint8_t Layer, Graphics_Object_t *target);

/******************************* Internal Data  **********************************/

extern FLIB_State_t FLIB_State[];
extern FLIB_CallbackType FLIB_CallbackAnimator[];
extern FLIB_AnimLayer_t* FLIB_AnimationData;

extern Graphics_Object_t *FLIB_GObjectCurrent[];
extern Graphics_Object_t FLIB_GObjectTmpBuffer1[];
extern Graphics_Object_t FLIB_GObjectTmpBuffer2[];



#endif
